module RevenueReporting
  class PayoutDetailsController < RevenueReporting::BaseController
    def index
      authorize PayoutDetail

      return if params[:payout_details].blank?

      form = params[:payout_details]
      channel_id = form[:channel_id]
      channel_login = form[:channel_login]

      channel = if channel_id.present?
                  Twitch::User.find(channel_id)
                elsif channel_login.present?
                  Twitch::User.find_by_login(channel_login)
                end

      if channel.blank?
        flash[:error] = "No channel found for: #{id_or_login(channel_id, channel_login)}"
        return redirect_to(revenue_reporting_payout_details_path)
      end

      @channel_id = channel.id.to_s
      @payout_details = RevenueReporting::PayoutDetail.all_prime(@channel_id)

      if @payout_details.nil?
        flash[:error] = "Error searching for user's payout detail records, please try again later."
      elsif @payout_details.empty?
        flash[:info] = "No history found for #{id_or_login(channel_id, channel_login)}."
      end
    end

    private

    def id_or_login(id, login)
      id.present? ? id : login
    end
  end
end