module Rewards
  class ObjectivesController < Rewards::BaseController
    def index
      authorize Objective

      campaign_id = params['objective'].try(:[], 'campaign_id')
      @objectives =
        if campaign_id
          Objective.find_by_campaign_id(campaign_id)
        else
          []
        end
      @triggers =
        if campaign_id
          Trigger.find_by_campaign_id(campaign_id)
        else
          []
        end
    end
  end
end
