module Rewards
  class RewardsController < Rewards::BaseController

    def index
      authorize Reward

      milestone_id = params['rewards'].try(:[], 'milestone_id')
      trigger_id = params['trigger'].try(:[], 'trigger_id')
      @milestone_rewards =
        if milestone_id
          Reward.find_by_milestone_id(milestone_id)
        else
          []
        end
      if trigger_id
        trigger_rewards = Reward.find_by_trigger_id(trigger_id)
        @trigger_benefactor_rewards = trigger_rewards.benefactor_rewards
        @trigger_recipient_rewards = trigger_rewards.recipient_rewards
      else
        @trigger_benefactor_rewards = []
        @trigger_recipient_rewards = []
      end
    end
  end
end
