# frozen_string_literal: true

module Staff
  class MembersController < Staff::BaseController
    before_action :authorize_action

    def index
      if params[:id].present?
        return redirect_to(staff_member_path(params[:id]))
      end
    end

    def show
      set_item
    end

    protected

    def authorize_action
      authorize Member
    end

    def set_item
      @member = Member.find params[:id]

      unless @member.errors.empty?
        flash[:warning] = 'User may be partially loaded.'
        flash[:error] = @member.errors
      end
    end
  end
end
