module Subscriptions
  class BadgeTimeoutStatusesController < Subscriptions::BaseController
    def update
      channel_id = params[:channel_id]

      authorize BadgeTimeoutStatus

      timeout_status = BadgeTimeoutStatus.find_by(channel_id: channel_id)

      if timeout_status.update(badge_timeout_status_params)
        flash[:success] = "Successfully updated badge timeout status for channel ID #{channel_id}"
      else
        flash[:error] = timeout_status.errors.full_messages.to_sentence
      end

      redirect_to subscriptions_channel_badges_path(channel_id: channel_id)
    end

    private

    def badge_timeout_status_params
      attributes = params.require(:subscriptions_badge_timeout_status).permit(:expires_on, :timed_out)
      attributes[:ldap] = current_user.ldap_login

      attributes
    end
  end
end
