module Subscriptions
  class BaseController < ApplicationController
  end

  TrackedEvent::Scaffold.class_eval do
    # rubocop:disable Layout/TrailingWhitespace
    #
    # @param [String] user_login the twitch user login to look up tenure for
    # @param [String] channel_login the twitch channel login to look up user_id or user_login's tenure on
    # @param [String] user_id the twitch user id to look up tenure for
    # @param [String] channel_id the twitch channel id to look up user_id or user_login's tenure on
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # note:
    # ---
    #   - when `user_login` AND `user_id` are submitted, `user_login` is IGNORED
    #   - when `channel_login` AND `channel_id` are submitted, `channel_login` is IGNORED
    # ---
    # @macro eventer
    def admin_panel_resub_tokens_search(
      user_login:,
      channel_login:,
      user_id:,
      channel_id:
    )
      build(context: binding)
    end

    #
    # @param [String] user_login the twitch user login to look up tenure for
    # @param [String] channel_login the twitch channel login to look up user_id or user_login's tenure on
    # @param [String] user_id the twitch user id to look up tenure for
    # @param [String] channel_id the twitch channel id to look up user_id or user_login's tenure on
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # note:
    # ---
    #   - when `user_login` AND `user_id` are submitted, `user_login` is IGNORED
    #   - when `channel_login` AND `channel_id` are submitted, `channel_login` is IGNORED
    # ---
    # @macro eventer
    def admin_panel_tenures_search(user_login:, channel_login:, user_id:, channel_id:)
      build(context: binding)
    end

    #
    # @param [String] emote_id the ID of the emote
    # @param [String] code_suffix the activation Code of the emote, without prefix
    #        e.g.,    "Kappa", "OhMyDog"
    # @param [String] group_id the ID of the group that this emote belongs to
    #        (formerly emote set id)
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_ticket_product_emote_deactivate(emote_id:, code_suffix:, group_id:)
      build(context: binding)
    end

    #
    # @param [String] emote_id the ID of the emote
    # @param [String] code_suffix the activation Code of the emote, without prefix
    #        e.g.,    "Kappa", "OhMyDog"
    # @param [String] group_id the ID of the group that this emote belongs to
    #        (formerly emote set id)
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_ticket_product_emote_update(emote_id:, code_suffix:, group_id:)
      build(context: binding)
    end

    #
    # @param [String] user_id the channel ID that owns the new emote
    # @param [String] code_suffix the activation Code of the emote, without prefix
    #        e.g.,    "Kappa", "OhMyDog"
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_ticket_product_emote_upload(user_id:, code_suffix:)
      build(context: binding)
    end

    #
    # @param [String] prefix the channel's text prefix,
    #        e.g.,    "support" in "supportSup"
    # @param [String] prefix_state the channel prefix's approval state,
    #        i.e.,    "active", "unset", "pending", "rejected"
    # @param [String] channel_id the ID of the channel that is changing its emote prefix
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_ticket_product_emote_prefix_update(prefix:, prefix_state:, channel_id:)
      build(context: binding)
    end

    #
    # @param [String] ticket_product_id the ID of the ticket_product being granted access for
    # @param [String] recipient_login the twitch login of the user receiving the benefit
    # @param [String] payment_provider the payment provider used for the purchase
    # @param [String] product_type the product type,  
    #        e.g.,    "Bits", "Channel Sub", "Gift Sub", "Sub Token"
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_benefit_grant(ticket_product_id:, recipient_login:, payment_provider: "admin", product_type:)
      build(context: binding)
    end

    #
    # @param [String] product_owner_login the login of the user that owns the product
    # @param [String] product_owner_id the user_id of the user that owns the product
    # @param [String] product_short_name the product's short_name,  
    #        e.g.,    "twitchsupport", "twitchsupport_3000"
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_ticket_product_search(product_owner_login:, product_owner_id:, product_short_name:)
      build(context: binding)
    end
    # rubocop:enable Layout/TrailingWhitespace
  end
end
