module Subscriptions
  class FixLatestController < Subscriptions::BaseController
    def update
      authorize Ticket
      @ticket = Ticket.save(params[:tenure])

      if !@ticket.errors.present?
        flash[:success] = "Success"
      else
        flash[:error] = @ticket.errors.full_messages.to_sentence
      end

      redirect_back
    end
  end
end