module Subscriptions
  class PendingEmoticonPrefixesController < Subscriptions::BaseController

    PENDING_PREFIX_LIMIT = 20

    def index
      authorize PendingEmoticonPrefix

      @pending_prefixes = Mako::EmotePrefix.get_pending_prefixes(PENDING_PREFIX_LIMIT)
    end

    def update
      authorize PendingEmoticonPrefix

      form_params = params[:mako_emote_prefix]
      prefix = form_params[:prefix]
      state = form_params[:state]
      channel_id = form_params[:channel_id]

      begin
        Mako::EmotePrefix.set_prefix(channel_id, prefix, state)

        flash[:success] = "Successfully updated emoticon prefix"

        track_action! trackable_request
          .assemble_an
          .admin_panel_ticket_product_emote_prefix_update(
            prefix: prefix,
            prefix_state: state,
            channel_id: channel_id
          )
      rescue StandardError
        flash[:error] = "Failed to update emoticon prefix"
      end
      redirect_back
    end
  end
end
