module SupportTools
  class UsersController < SupportTools::BaseController
    def index
      @job = SupportTools::UserJob.new
      authorize @job

      @suspension_guides = AegisGateway::suspension_guides.to_json
    end

    def create
      @job = SupportTools::UserJob.new job_params
      @job.reporter = current_user.ldap_login
      @job.reporter_email = current_user.email
      authorize @job

      @job.save

      if @job.errors.present?
        @suspension_guides = AegisGateway::suspension_guides.to_json
        flash.now[:danger] = @job.errors.full_messages.to_sentence
        render :index
      elsif @job.grouped
        flash[:warning] = "Your job was very large so we broke it into multiple jobs"
        redirect_to resque_jobs_jobs_path
      else
        flash[:success] = "Successfully created job"
        redirect_to resque_jobs_job_path(@job)
      end

      unless @job.errors.present?
        track_action! trackable_request.assemble_an.admin_panel_support_tools_submit(action: params[:job_type])
      end
    end

    protected

    def job_params
      defaults = { duration: 1 }
      params.require(:support_tools_user_job).permit(:users, :job_type, :content, :description, :reason, :detailed_reason, :is_permanent, :skip_ip_ban, :ban_partners, :ban_affiliates, :duration).reverse_merge(defaults)
    end
  end
end
