module Tools
  class BaseController < ApplicationController

    TrackedEvent::Scaffold.class_eval do

      # Definition for translate_text
      #
      # @param [String] source_text_language "from" language code
      # @param [String] output_text_language "to" language code
      # @param [String] source_text_length the length of the "from" text
      # @param [String] source_text_hash a hash of the "from" text
      #
      # @return (see TrackedEvent::Scaffold#build)
      #
      def admin_panel_translate_text(
        source_text_language:,
        output_text_language:,
        source_text_length:,
        source_text_hash:
      )
        build(context: binding)
      end
    end
  end
end
