
class TrackingController < ApplicationController
  DISABLED = begin
    Settings.activity_log.disable
  rescue Settingslogic::MissingSetting
    false
  end

  skip_before_action :verify_authenticity_token, :authentication_required, :only => [:heartbeat]

  before_action :check?, :only => [:heartbeat]

  skip_after_action :verify_authorized

  def heartbeat
    duration = params[:duration].to_i
    is_active_tab = params[:is_active_tab]
    location = params[:location]

    EventTracker.admin_panel_page_view_heartbeat(user_info_for_tracking, location, duration, is_active_tab)
  end

  def check?
    unless !DISABLED && signed_in?
      head :forbidden
      return false
    end
  end

end
