module Transactions
  class EntriesController < Transactions::BaseController

    def index
      authorize Entry

      @search_types = ["ONSITE", "EXTENSION"]

      if form_is_blank
        @transactions = []
      else
        resp = Entry.search(params)
        @transactions = resp['transactions']
        @cursor = resp['cursor']
      end
    end

    def form_is_blank
      form_fields = [
        :event_search_type,
        :user,
        :channel,
        :start_event_time,
        :end_event_time
      ]
      form_fields.each do |field|
        return false unless params[field].to_s.blank?
      end
      true
    end
  end
end