module Twitch
  class AdminsController < Twitch::BaseController
    def index
      authorize Twitch::User
      privileged_users = GlobalPrivilegedUsers.get

      @admins = privileged_users[:admins].sort
      @subadmins = privileged_users[:subadmins].sort
      @global_mods = privileged_users[:global_mods].sort

      @num_admins = @admins.length
      @num_subadmins = @subadmins.length
      @num_global_mods = @global_mods.length
    end
  end
end
