module Twitch
  class BaseController < ApplicationController
  end

  TrackedEvent::Scaffold.class_eval do
    #
    # @param [String] query which user identifier was searched for (id, login, phone, etc)
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_user_search(query:)
      build(context: binding)
    end

    #
    # @param [String] user_id the ID of the user being impersonated
    # @param [String] reason the goal of this impersonation session
    # @param [String] reference an optional ticket or issue ID serving as reference for an impersonation session
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_user_impersonate(user_id:, reason:, reference:)
      build(context: binding)
    end

    #
    # @param [String] user_id the active profile's current user_id
    # @param [String] geoip_entry the IP address entered for comparison
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_profile_geoip_submit(user_id:, geoip_entry:)
      build(context: binding)
    end

    #
    # @param [String] team_name the short_name/url of the team
    # @param [String] team_display_name the friendly name of the team
    # @param [String] team_owner_login the username of the team owner
    # @param [String] team_owner_id the user_id associated with the team_owner_login
    # @param [String] team_description the text/markdown description of the team
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_teams_create(
      team_name:,
      team_display_name:,
      team_owner_login:,
      team_owner_id:,
      team_description:
    )
      build(context: binding)
    end

    #
    # @param [String] query which team identifier was searched for (name, short_name, etc)
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_teams_search(query:)
      build(context: binding)
    end
  end
end
