module Twitch
  class ChannelsController < Twitch::BaseController
    before_action :set_channel

    def update
      response = @user.update_channel(params)
      if response.success?
        flash[:success] = "Successfully modified channel #{@user.login}"
      else
        flash[:error] = "#{response.body['message']}. Channel could not be updated."
      end
      redirect_to @user
    end

    protected

    def set_channel
      @user = User.find params[:user_id]

      if @user.blank?
        flash[:error] = "Channel not found"
        redirect_to twitch_users_path
      end

      authorize @user
    end
  end
end
