module Twitch
  class ChatController < Twitch::BaseController
    before_action :set_user

    def disconnect_chat_sessions
      success = @user.disconnect_chat_sessions
      if success
        flash[:success] = 'Successfully disconnected user\'s chat sessions'

        track_action! trackable_request
          .assemble_an
          .admin_panel_button(
            button: "disconnect_from_chat",
            user_id: params[:user_id]
          )
      else
        flash[:danger] = 'Failed to disconnect user\'s chat sessions'
      end
      redirect_to @user
    end

    def set_user
      @user = User.find params[:user_id]

      if @user.blank?
        flash[:error] = "User not found"
        redirect_to twitch_users_path
      end

      authorize @user
    end
  end
end
