module Twitch
  class ReportClipsController < ApplicationController
    def destroy
      authorize(SupportTools::AegisGateway, 'report_clips?')

      audit = History::Audit.new(
        action: "delete_report_clips",
        user_type: "ldap_user",
        user_id: current_user.ldap_login,
        resource_type: "report_clips",
        resource_id: params[:user_id]
      )

      History::AddAudit.add(audit)

      @job = DeleteReportClipsJob.create(user_id: params[:user_id])
      redirect_to resque_jobs_job_path(@job)
    end
  end
end
