module Twitch
  class SessionsController < Twitch::BaseController
    before_action :set_user

    def delete_all_cookies
      success = @user.delete_all_cookies
      if success
        flash[:success] = 'Successfully deleted all user\'s cookies'

        track_action! trackable_request
          .assemble_an
          .admin_panel_button(
            button: "delete_user_cookies",
            user_id: params[:user_id]
          )
      else
        flash[:danger] = 'Failed to delete user\'s cookies'
      end
      redirect_to @user
    end

    def set_user
      @user = User.find params[:user_id]

      if @user.blank?
        flash[:error] = "User not found"
        redirect_to twitch_users_path
      end

      authorize @user
    end
  end
end
