module Twitch
  class SuspensionsController < ApplicationController
    def destroy
      authorize SupportTools::UserJob

      @user = User.find params[:user_id]

      ldap_login = current_user.ldap_login
      description = "unban #{@user.displayname} id: #{@user.id} by #{ldap_login}"
      options = {
        "reporter" => ldap_login,
        "description" => description,
      }

      options[:decrement] = params[:decrement].to_i
      options[:types] = [("tos" if params[:tos]), ("dmca" if params[:dmca])].compact

      success = @user.tos_unban(options)
      if success
        flash[:success] = "Success: User has been unbanned"
      else
        flash[:error] = "Error unbanning user"
      end
      redirect_to twitch_user_path(params[:user_id])
    end
  end
end
