module Twitch
  class UserChannelPropertiesController < Twitch::BaseController
    INTEGER_PARAMS = [:delay_length, :hls_segment_duration, :num_backup_streams_allowed, :disconnect_slate_duration]
    BOOLEAN_PARAMS = [:source_restricted, :save_vods, :delay_controls_enabled, :drm_enabled, :backup_controls_enabled, :disconnect_slate_controls_enabled]
    before_action :set_channel

    def edit
    end

    def update
      if @channel_property.update(update_params)
        flash[:success] = "Success"
        redirect_to edit_twitch_user_channel_property_path(@channel_property)
      else
        flash.now[:danger] = @channel_property.errors
        render :edit
      end
    end

    def regenerate_stream_key
      if @channel_property.regenerate_stream_key
        flash[:success] = "Success"
        redirect_to edit_twitch_user_channel_property_path(@channel_property)
      else
        flash.now[:danger] = @channel_property.errors
        render :edit
      end
    end

    def remove_authorized_stream_key
      permitted = params.permit(:id, :email)
      if @channel_property.remove_authorized_stream_key(permitted)
        flash[:success] = "Success"
        redirect_to edit_twitch_user_channel_property_path(@channel_property)
      else
        flash.now[:danger] = @channel_property.errors
        render :edit
      end
    end

    def add_authorized_stream_key
      permitted = params.permit(:id, authorized_stream_key:[:email])
      if @channel_property.add_authorized_stream_key(permitted)
        flash[:success] = "Success"
        redirect_to edit_twitch_user_channel_property_path(@channel_property)
      else
        flash.now[:danger] = @channel_property.errors
        render :edit
      end
    end

    def disconnect
      if @channel_property.disconnect
        flash[:success] = "Disconnected channel!"
        redirect_to edit_twitch_user_channel_property_path(@channel_property)
      else
        flash.now[:danger] = @channel_property.errors
        render :edit
      end
    end

    protected

    def set_channel
      @channel_property = Twitch::UserChannelProperty.find params[:user_id]
      unless @channel_property.errors.empty?
        flash[:error] = @channel_property.errors
        redirect_to twitch_users_path
        return
      end
      authorize @channel_property
    end

    def update_params
      permitted = params.require(:twitch_user_channel_property).permit(:id, :transcode_type, :delay_length, :hls_segment_duration, :source_restricted, :save_vods, :delay_controls_enabled, :latency, :drm_enabled, :num_backup_streams_allowed, :disconnect_slate_duration, :backup_controls_enabled, :disconnect_slate_controls_enabled)
      INTEGER_PARAMS.each do |key|
        if permitted.key?(key)
          permitted[key] = permitted[key].to_i
        end
      end
      BOOLEAN_PARAMS.each do |key|
        if permitted.key?(key)
          permitted[key] = permitted[key] == "1"
        end
      end
      permitted
    end
  end
end
