module Twitch
  class ValidatedNonPartnerController < Twitch::BaseController
    before_action :set_user

    def edit
    end

    def update
      vnp = Twitch::User.booleanize(params[:validated_non_partner])
      res = if vnp
              Ripley::ValidatedNonPartner.add(@user.id.to_s)
            else
              Ripley::ValidatedNonPartner.delete(@user.id.to_s)
            end

      if res.error.nil?
        flash[:success] = "Successfully updated validated non partner to #{vnp}"
      else
        flash[:error] = "Unable to update: #{res.error}"
      end

      redirect_to twitch_user_path(id: params[:user_id])
    end

    protected

    def set_user
      @user = User.find params[:user_id]

      authorize @user, :manage_validated_non_partner?
    end
  end
end
