module UserRewards
  class BaseController < ApplicationController
  end

  TrackedEvent::Scaffold.class_eval do
    # Tracking definition for hype train rewards granting queries
    #
    # @param [String] channel_id the channel for which the hype train happened on
    # @param [String] user_id the user who contributed to the hype train
    # @param [String] timestamp the approximate time of contribution made by the user
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    def admin_panel_hype_train_rewards_grant_query(
      channel_id:,
      user_id:,
      timestamp:
    )
      build(context: binding)
    end
    # rubocop:enable
  end

  TrackedEvent::Scaffold.class_eval do
    # Tracking definition for bits badge tier rewards granting queries
    #
    # @param [String] channel_id the channel for which to check bits badge tiers for
    # @param [String] user_id the user who used bits in the channel
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    def admin_panel_bits_badge_tier_rewards_grant_query(
      channel_id:,
      user_id:
    )
      build(context: binding)
    end
    # rubocop:enable
  end
end
