module UserRewards
  class BitsBadgeTiersController < UserRewards::BaseController

    def index
      authorize BitsBadgeTier
    end

    def grant_unlocked_rewards
      authorize BitsBadgeTier

      @user_id = params[:bits_badge_tier][:user_id]
      @channel_id = params[:bits_badge_tier][:channel_id]

      track_action! trackable_request.assemble_an.admin_panel_bits_badge_tier_rewards_grant_query(
        user_id: @user_id,
        channel_id: @channel_id
      )

      begin
        @total_bits_cheered =
          BitsBadgeTier.grant_unlocked_rewards(@user_id, @channel_id) || 0

        @emotes = BitsBadgeTier.unlocked_emotes(@user_id, @channel_id).sort_by { |emote| emote.badge_tier_summary.badge_tier_threshold }
      rescue StandardError => e
        flash[:error] = "Failed to grant unlocked bits badge tier rewards #{e.message}"
      ensure
        render "index"
      end
    end
  end
end
