module VodAppeals
  class AppealsController < VodAppeals::BaseController
    def index
      authorize Vods::VodAppeal

      @unresolved_appeals = Vods::VodAppeal.all(params)
    end

    def resolve
      authorize Vods::VodAppeal

      @appeal = Vods::VodAppeal.find(params[:id])
      response = @appeal.resolve

      if response.error
        flash[:warning] = response.error.msg
        return redirect_to(vods_vod_path(id: params[:vod_id]))
      end

      flash[:success] = "Vod appeal was resolved."
      track_action! trackable_request
        .assemble_an
        .admin_panel_vod_appeal_resolve(
          vod_id: params[:vod_id],
          vod_appeal_id: params[:id]
        )
      return redirect_to(vod_appeals_appeals_path)
    end
  end
end
