module Vods
  class BaseController < ApplicationController
  end

  TrackedEvent::Scaffold.class_eval do
    # rubocop:disable TrailingWhitespace
    #
    # @param [String] vod_id the ID of the vod associated with the Vod Appeal
    # @param [String] audible_magic_response_id the unique response ID from the content scan
    # @param [String] vod_track_appeal_id the ID of the specific track appeal
    # @param [String] vod_track_appeal_action the action taken on the appealed segment,  
    #        i.e,     "accept", "reject"
    # @param [String] vod_appeal_id the ID of the Vod Appeal that track appeals are associated with
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_vod_appeal_track_action(
      vod_id:,
      audible_magic_response_id:,
      vod_track_appeal_id:,
      vod_track_appeal_action:,
      vod_appeal_id:
    )
      build(context: binding)
    end
  end
  # rubocop:enable TrailingWhitespace
end
