module Vods
  class TrackAppealsController < Vods::BaseController
    def resolve
      authorize TrackAppeal

      @appeal = TrackAppeal.find(params[:id])
      @appeal.resolve(params[:appeal_action])

      @vod = Vods::Vod.find params["vod_id"]
      @amr = @vod.audible_magic_responses.find { |amr| amr.track_appeal.present? && amr.track_appeal.id.to_s == @appeal.id.to_s }

      respond_to do |format|
        format.js
      end
      track_action! trackable_request
        .assemble_an
        .admin_panel_vod_appeal_track_action(
          vod_id: params[:vod_id],
          audible_magic_response_id: @appeal.audible_magic_response_id,
          vod_track_appeal_id:       params[:id],
          vod_track_appeal_action:   params[:appeal_action],
          vod_appeal_id:             @appeal.vod_appeal_id
        )
    end
  end
end
