module Vods
  class VodsController < ApplicationController
    before_action :set_vod, only: [:show, :destroy, :download]

    def index
      authorize Vod

      unless params[:vod].blank?
        redirect_to vods_vod_path(id: params[:vod][:id])
        return
      end
    end

    def show
    end

    def destroy
      hard_delete = Vod.booleanize(params[:destructive])
      if hard_delete
        @vod.hard_delete
      else
        @vod.soft_delete
      end

      flash[:success] = "Vod deleted. It will take a few seconds for changes to take effect."
      redirect_back
    end

    def undestroy
      @vod = Vod.from_attributes id: params[:id]
      authorize @vod

      @vod.undelete
      flash[:success] = "Vod undeleted."
      redirect_back
    end

    def download
      @job = SupportTools::DownloadVOD.new id: params[:id]
      if @job.save
        redirect_to resque_jobs_job_path(@job)
      else
        flash[:danger] = @job.errors.full_messages.to_sentence
        redirect_back
      end
    end

    protected

    def set_vod
      @vod = Vod.find params[:id]

      if @vod.blank?
        flash[:error] = "VOD with ID " + params[:id] + " was not found."
        return redirect_to(vods_vods_path)
      end

      authorize @vod
    end
  end
end
