module Zuma
  class BaseController < ApplicationController
    def set_user
      user = params[:user].presence
      if user.present?
        @twitch_user = get_user_from_string(user)
      end
    end

    def set_blocked_user
      blocked_user = params[:blocked_user].presence
      if blocked_user.present?
        @blocked_user = get_user_from_string(blocked_user)
      end
    end

    protected

    def get_user_from_string(user_string)
      if /^\d+$/.match?(user_string)
        Twitch::User.find(user_string)
      else
        Twitch::User.find_by_login(user_string)
      end
    end
  end
end
