module Zuma
  class UserBlocksController < Zuma::BaseController
    before_action :set_user, only: [:index]

    def index
      authorize UserBlock
      blocked_users = []
      if @twitch_user.present?
        user_block = UserBlock.all(@twitch_user.id)
        if user_block.present?
          user_block.blocked_user_ids.each do |user_id|
            login = Twitch::User.find(user_id).login
            blocked_users << [user_id, login]
          end
        end
      end
      @user_block = blocked_users
    end
  end
end
