module BeefCake
  module MembershipHelper
    def expiration(expires_at)
      expiration = "Never"
      if expires_at.present?
        expiration = if expires_at < Time.now
                       "Expired"
                     else
                       expires_at
                     end
      end
      expiration
    end

    def sort_by_date(memberships)
      expired = memberships.select {|a| a.expires_at && a.expires_at < Time.now}
      not_expired = (memberships.reject {|a| a.expires_at && a.expires_at < Time.now})
                    .sort_by(&:role_name)
      return not_expired.concat(expired)
    end
  end
end
