module Bits
  module BadgesHelper
    def custom_badge_title?(badge_tier)
      if @default_badges.dig("versions", badge_tier['threshold'].to_s)
        return badge_tier['title'] != @default_badges['versions'][badge_tier['threshold'].to_s]['title']
      end

      # default to compare the title against our known Bits prefix
      badge_tier['title'] != "cheer #{badge_tier['threshold']}"
    end

    def custom_badge_images?(badge_tier)
      if @default_badges.dig("versions", badge_tier['threshold'].to_s)
        default_badge = @default_badges['versions'][badge_tier['threshold'].to_s]
        return badge_tier['image_url_1x'] != default_badge['image_url_1x'] \
               || badge_tier['image_url_2x'] != default_badge['image_url_2x'] \
               || badge_tier['image_url_4x'] != default_badge['image_url_4x']
      end

      # default to true so that we display this to admins if we can't find the global default image
      true
    end
  end
end
