module Bits
  TIME_ZONE = "Pacific Time (US & Canada)"
  
  module TransactionsHelper
    def get_bits_user_link(id)
      "/bits/users/#{id}"
    end

    def format_timestamp(timestamp)
      DateTime.rfc3339(timestamp).in_time_zone(TIME_ZONE).strftime("%Y-%m-%d %H:%M:%S %Z")
    end
  end
end
