module History
  TIME_ZONE = "Pacific Time (US & Canada)"

  module QueryAuditHelper
    def resource_string(type, id)
      str = ""
      str << type if type.present?
      str << ":" if type.present? && id.present?
      str << id if id.present?
      return str
    end

    def audit_display_user_string(type, id)
      link_to_if(type == Twitch::User::AUDIT_TWITCH_USER, "#{type}:#{id}", twitch_user_path(id))
    end

    def format_audit_timestamp(timestamp)
      DateTime.rfc3339(timestamp).in_time_zone(TIME_ZONE).strftime("%Y-%m-%d %H:%M:%S %Z")
    end
  end
end
