module Payments
  # rubocop:disable Metrics/ModuleLength
  module PurchaseOrderHelper
    include Subscriptions::TicketProductHelper
    PLATFORM_DISPLAY_NAMES = {
      "Web" => :web,
      "Android" => :android,
      "iOS" => :ios
    }

    PURCHASE_ORDER_STATE_DISPLAY_NAMES = {
      "Success" => :success,
      "Failed" => :failed
    }

    PAYMENT_GATEWAY_DISPLAY_NAMES = {
      "Recurly" => :recurly,
      "Xsolla" => :xsolla_v3,
      "Zuora" => :zuora,
      "Google IAB" => :google_iab,
      "Apple IAP" => :apple_iap,
      "Sub Token" => :sub_token
    }

    PRODUCT_TYPE_DISPLAY_NAMES = {
      "Bits" => :bits,
      "Channel Sub" => :sub,
      "Gift Sub" => :gift_sub,
      "Sub Token" => :sub_token
    }

    PURCHASE_ORDER_ERROR_DISPLAY_NAMES = {
      "5001" => "Entitlement Failed",
      "4006" => "Ineligible Purchase",
      "4005" => "Invalid Payment Method",
      "4001" => "Bank Declined",
      "4002" => "Fraud Blocked",
      "4003" => "Velocity Limit Exceeded",
      "5000" => "System Error",
      "4000" => "Invalid Arguments",
      "4004" => "Two Factor Disabled"
    }

    def options_for_platform_select(platform)
      options_for_select(PLATFORM_DISPLAY_NAMES, platform)
    end

    def options_for_purchase_order_state_select(state)
      options_for_select(PURCHASE_ORDER_STATE_DISPLAY_NAMES, state)
    end

    def options_for_payment_gateway_select(payment_gateway)
      options_for_select(PAYMENT_GATEWAY_DISPLAY_NAMES, payment_gateway)
    end

    def options_for_product_type_select(product_type)
      options_for_select(PRODUCT_TYPE_DISPLAY_NAMES, product_type)
    end

    def purchase_order_details_label(details)
      if PURCHASE_ORDER_ERROR_DISPLAY_NAMES.key?(details)
        PURCHASE_ORDER_ERROR_DISPLAY_NAMES[details]
      else
        details
      end
    end

    def purchase_order_state_label(state)
      if state == "success"
        haml_tag :span, "success", class: "label label-success"
      else
        haml_tag :span, state.to_s, class: "label label-danger"
      end
    end

    def subscription_state_label(state)
      case state.to_sym
      when :active
        haml_tag :span, "active", class: "label label-success"
      when :will_not_renew
        haml_tag :span, "will not renew", class: "label label-default"
      when :cancelled
        haml_tag :span, "canceled", class: "label label-danger"
      else
        haml_tag :span, state.to_s, class: "label label-default"
      end
    end

    def purchase_order_payment_state_label(state)
      case state.to_sym
      when :success
        haml_tag :span, "success", class: "label label-success"
      else
        haml_tag :span, state.to_s, class: "label label-danger"
      end
    end

    def purchase_order_recurring_payment_state_label(state)
      case state.to_sym
      when :active
        haml_tag :span, "active", class: "label label-success"
      when :will_not_renew
        haml_tag :span, "will not renew", class: "label label-default"
      when :cancelled
        haml_tag :span, "cancelled", class: "label label-danger"
      else # intermediate state
        haml_tag :span, state.to_s, class: "label label-danger"
      end
    end

    def item_fulfillment_state_label(state)
      case state.to_sym
      when :fulfilled
        haml_tag :span, "fulfilled", class: "label label-success"
      when :pending
        haml_tag :span, "pending", class: "label label-default"
      when :failed
        haml_tag :span, "failed", class: "label label-danger"
      end
    end

    def gift_label(is_gift)
      if is_gift
        haml_tag :span, "true", class: "label label-success"
      else
        haml_tag :span, "false", class: "label label-danger"
      end
    end
  end
  # rubocop:enable Metrics/ModuleLength
end
