module Payments
  module PurchaseProfileHelper
    include Subscriptions::TicketProductHelper

    def options_for_state_select(state)
      options_for_select(PurchaseProfile::STATES, state)
    end

    def options_for_payment_provider_select(state)
      options_for_select(PurchaseProfile::PAYMENT_PROVIDERS, state)
    end

    def state_label(state)
      if state == "active"
        haml_tag :span, "active", class: "label label-success"
      else
        haml_tag :span, "#{state}", class: "label label-danger"
      end
    end

    def is_gift_label(is_gift)
      if is_gift
        haml_tag :span, "true", class: "label label-success"
      else
        haml_tag :span, "false", class: "label label-danger"
      end
    end

    def get_show_purchase_profile_back_url
      if request.referer && request.referer.include?("purchase_payment")
        payments_purchase_profiles_path
      else
        :back
      end
    end
  end
end
