module Payments
  module PurchaseRefundHelper
    FRAUD_REASON = {
        "ATO Fraud" => :ato_fraud,
        "Friendly Fraud" => :friendly_fraud,
        "Stolen Card" => :stolen_card,
        "Goodwill (i.e. hardship)" => :goodwill,
        "Product Bug / Issue" => :bugs,
        "Legal Request" => :legal_request,
        "Other" => :other
    }

    def options_for_refund_reason(reason)
      options_for_select(FRAUD_REASON, reason)
    end
  end
end
