module ResqueJobs
  module JobHelper
    def job_progress_status(job)
      return "Waiting for worker..." if @job.queued?
      return "Processing #{@job.num}/#{@job.total} (#{@job.pct_complete})" if @job.working?
      return "Processed #{@job.total} records" if @job.completed?
      return "#{@job.status.titleize} at #{@job.num}/#{@job.total}" if @job.num.present? && @job.total.present?
      return @job.status.titleize
    end

    def job_status_badge(status)
      label_class = "default"

      Resque::Plugins::Status.tap do |s|
        label_class = {
          s::STATUS_QUEUED => "default",
          s::STATUS_WORKING => "primary",
          s::STATUS_COMPLETED => "success",
          s::STATUS_KILLED => "danger",
          s::STATUS_FAILED => "danger",
        }[status]
      end

      haml_tag :span, status, class: "label label-#{label_class} status"
    end
  end
end
