module RevenueReporting
  module PayoutDetailHelper
    def display_month(month_number)
      return nil if month_number.blank?
      Date::MONTHNAMES[month_number.to_i]
    end

    def display_price(price, currency)
      return nil if price.blank? || currency.blank?
      Money.new(price, currency).format
    end
  end
end