module RevenueReporting
  module ReportHelper
    # display_state hides the "state:" prefix
    def display_state(state)
      state.sub("state:", "").titleize
    end

    # display_date reformats a date as ISO8601
    def display_date(date)
      Date.parse(date).strftime("%F")
    end

    # display_time reformats a date as a time
    def display_time(date)
      dt = Time.parse(date).in_time_zone("Pacific Time (US & Canada)")
      "#{dt.strftime('%l:%M %p')}, #{time_ago_in_words(dt)} ago"
    end

    # display_report_type displays the pretty name for reports
    def display_report_type(report_type)
      (revenue_report_types + other_report_types).find { |t| t.first == report_type }.try(:last)
    end

    def revenue_report_types
      [
        ["product_revenue", "Subs: Revenue (by Partner)"],
        ["product_revenue_by_product", "Subs: Revenue (by Partner/Product)"],
        ["product_revenue_by_product_date", "Subs: Revenue (by Partner/Product/Date)"],
        ["ad_revenue", "Ads: Revenue (by Partner)"],
        ["samus_revenue", "Prime Subs: Revenue (by Partner)"],
        ["samus_payout", "Prime Subs: Net-15 Hybrid Payout"],
        ["bounty_board_revenue", "Bounty Board: Revenue (by Partner/Campaign)"],
        ["bits_extension_developer_payout", "Bits in Extensions: Developer"],
        ["bits_extension_broadcaster_payout", "Bits in Extensions: Broadcaster"],
        ["bits_mega_report", "Bits: Mega Report"],
        ["bits_emote_royalty_v2", "Bits: Emote Royalty V2"],
        ["soft_landing_accounting", "Soft Landing"],
        ["blended_fee_combination_revenue", "All Payouts (Blended Fee)"],
        ["combination_revenue", "All Payouts"]
      ]
    end

    # other_report_types includes reports that do not belong in revenue_report_types
    def other_report_types
      [
        ["tax_withholding_rates", "Tax Withholding Rates (by Channel)"]
      ]
    end

    def last_month
      Date.today.at_beginning_of_month - 1.month
    end

  end
end
