module Subscriptions
  module BadgeHelper
    def subscriptions_badge_name_label(month:)
      if month.blank? || !month.is_a?(Integer)
        return haml_tag :span, "N/A", class: "label label-default"
      end

      if month.zero?
        text = "Base"
      elsif (month % 12).zero?
        text = "#{month / 12}-Year"
      else
        text = "#{month}-Month"
      end

      haml_tag :span, text, class: "label label-primary"
    end

    def subscriptions_badge_image(src:, title:, alt:)
      if src.blank?
        return haml_tag :span, "N/A", class: "label label-default"
      end

      haml_tag :img, src: src, title: title, alt: alt
    end
  end
end
