module Subscriptions
  module TicketProductHelper
    def format_ticket_product_interval(number, unit)
      return "" if unit.blank?

      unit.gsub!("_", " ") if unit.is_a?(String)

      number.blank? ? unit : "#{number} #{unit}"
    end

    def ticket_product_availability_span_label(availability)
      if availability == "active"
        haml_tag :span, "Active", class: "label label-success"
      else
        haml_tag :span, "Inactive", class: "label label-danger"
      end
    end

    def interval_unit_types
      [
        ["month", "month"],
        ["one_time", "one_time"],
        ["year", "year"]
      ]
    end

    def ticket_types
      [
        ["chansub", "chansub"],
        ["teamsub", "teamsub"],
        ["turbo", "turbo"]
      ]
    end
  end
end
