module TrackingHelper
  def track_page_view
    user_info = {
      ldap: current_user.ldap_login,
      client_time: Time.now.to_f,
      user_agent: request.headers['User-Agent'],
      ip: request.remote_ip,
      session_id: request.session.id
    }
    page_url = request.original_url

    EventTracker.admin_panel_page_view(user_info, page_url)
  end
end
