module Twitch
  module EventHelper
    def event_status_span_label(status)
      case status
      when "available"
        haml_tag :span, "Available", class: "label label-success"
      when "creator_deleted"
        haml_tag :span, "Removed By User", class: "label label-warning"
      when "admin_deleted"
        haml_tag :span, "Removed By Admin", class: "label label-danger"
      else
        haml_tag :span, "Unknown", class: "label label-default"
      end
    end

    def remove_confirmation
      # We use `&#10;` with `raw()`, instead of `\n`,
      # because `\n` results in indentation in JavaScript.
      # See https://github.com/rails/rails/issues/16784.

      raw("Are you sure you want to remove this Twitch Event from the public?&#10;&#10;The cover image (if available) will be immediately removed from public access and subsequently deleted after 90 days.&#10;&#10;This action is IRREVERSIBLE.")
    end
  end
end
