module Twitch
  module UserChannelPropertyHelper
    def transcode_type_options
      return {
        '' => 'transmux (default)',
        'quicksync' => 'quicksync (cheap)',
        'twitchweb' => 'twitchweb (x264)',
        'event1080' => 'event1080 (x264, expensive)',
      }
    end

    def hls_segment_duration_options
      return {
        '0' => '0 (default)',
        '2' => '2 (short)',
        '4' => '4 (long)',
      }
    end

    def latency_mode_options
      return {
        'normal' => 'normal (default)',
        'low' => 'low',
      }
    end

    def transcode_type_str(channel)
      return "channel missing" unless channel && !channel.transcode_type.nil?
      transcode_type_options[channel.transcode_type]
    end

    def hls_segment_duration_str(channel)
      return "channel missing" unless channel && !channel.hls_segment_duration.nil?
      hls_segment_duration_options[channel.hls_segment_duration.to_s]
    end

    def stream_key_str(channel)
      return "channel missing" unless channel
      "live_#{channel.id}_#{channel.stream_key}"
    end

    def ask_stream_key_str(ask)
      return "channel missing" unless ask
      "live_sub_#{ask.stream_key}"
    end
  end
end
