class BaseJob < ResqueJobs::Base
  # Calls a function and retries on any failure
  def linear_retry(func, options = {})
    (0...((options[:tries] || 30) - 1)).each do

      return func.call
    rescue # rubocop:disable Style/RescueStandardError
      sleep(options[:rate] || 1.seconds)

    end

    func.call
  end
end
