class DeleteReportClipsJob < BaseJob
  SLEEP_DURATION_SECONDS = 0.1
  STEPS = ["deleting", "done"]

  def perform
    user_id = options["user_id"]
    cursor = nil
    count = 0
    loop do
      res = linear_retry(
        proc {
          SupportTools::AegisGateway.delete_report_clips_by_user({
            user_id: user_id,
            limit: 100,
            cursor: cursor,
          })
        }
      )
      if !res["page_info"]
        set_status(error_message: "failed to delete all report clips, deleted #{count}")
        break
      elsif res["page_info"]["next_cursor"].to_s.empty?
        completed
        break
      else
        count += 100
        at(1, STEPS.length, STEPS[0])
        cursor = res["page_info"]["next_cursor"]
      end
      sleep SLEEP_DURATION_SECONDS
    end
  end
end
