class DownloadVODJob < BaseJob
  SLEEP_DURATION_SECONDS = 1
  STEPS = ["created", "downloading", "transmuxing", "complete"]
  FAILED = "failed"
  COMPLETE = "complete"

  def perform
    downloader = Vods::Download.new
    loop do
      resp = linear_retry(proc { downloader.download(options['id']) })

      status = resp['status']['value']

      at(STEPS.find_index(status), STEPS.length - 1, status)
      case status
      when FAILED
        set_status(error_message: "failed to create download")
        break
      when COMPLETE
        completed('url' => resp.download_url.value)
        break
      end
      sleep SLEEP_DURATION_SECONDS
    end
  end
end
