class ForcePasswordResetJob < ResqueJobs::Base
  SLEEP_DURATION_SECONDS = 0.1
  
  def perform
    failed_logins = []
    logins = options["users"]
    logins.each do |login|
      user = Twitch::User.new(login: login)
      user.id = user.fetch_id
      success = user.force_password_reset
      failed_logins << login unless success
      sleep SLEEP_DURATION_SECONDS
    end

    unless failed_logins.empty?
      error_message = "Failed to force reset password #{failed_logins.join(', ')}"
      set_status(error_message: error_message)
    end
  end
end

