class UndeleteJob < ResqueJobs::Base
    SLEEP_DURATION_SECONDS = 0.1

    def perform
      users = options["users"]
      total = users.count
      failed_logins = []

      users.each.with_index(1) do |login, index|
        at_message = "Reactivating #{login}"
        at(index, total, at_message)
        user = Twitch::User.new(login: login)
        success = user.undelete(options["reporter"])
        failed_logins << login unless success
        sleep SLEEP_DURATION_SECONDS
      end

      if failed_logins.present?
        error_message = "Failed to reactivate "
        error_message << failed_logins.join(", ")
        set_status(error_message: error_message)
      end
    end
  end
