class ApplicationPolicy
  attr_reader :user, :record

  def initialize(user, record)
    @user = user
    @record = record
  end

  # implementations of ApplicationPolicy should override this # currently used
  # by the sidebar to determine if a sidebar item should be should show to a
  # user
  def allowed?
    return false
  end

  def scope
    Pundit.policy_scope!(user, record.class)
  end

  class Scope
    attr_reader :user, :scope

    def initialize(user, scope)
      @user = user
      @scope = scope
    end

    def resolve
      scope.scoped
    end
  end
end
